% Visualizes a combined clustered image
function [imgK,IDXs,Cs, color_arr] = Visualize_combined_ClusteredImage(IDX,C,S,indx,k)

n = S(1)*S(2);
Img = zeros(n,1);
JetColMap = jet; close();
LL = length(JetColMap);


if ~exist('k', 'var') || isempty(k)
    Img(indx) = IDX;   %index: : positions where the algorithm was applied
    imgK = reshape(Img,S(1),S(2));
    figure, imagesc(imgK);
    color_arr = 0;
else
    IDXs = IDX;
    Cs = C;
    for i = 1:k
        Cluster_Size(i) = length(find(IDX(:)==i));
    end
    %%%======Color the Cluster based on its size not randomely as given by kmeans
    [Sort SI] = sort(Cluster_Size);
    for i = 1:k
        clusterID = SI(i);
        IDXs(IDX== clusterID) = i;
        Cs(i,:) = C(clusterID,:);
    end
    
    Img(indx) = IDXs;
    imgK = reshape(Img,S(1),S(2));
    color_arr = round((LL/k): (LL/k): LL);
    figure, imagesc(imgK);
    title(strcat('Kmeans: ', num2str(k),'+ Background cluster'));
       colormap(JetColMap([1 color_arr],:));
end
